' * GEMS 'n' ROCKS *
' Martin Herhaus 2024
' For picomite VGA V50708 or later
Option explicit
Dim Lev$(33)Length 64,spr%(40),Sprit3%(11),ro$,Key$,mite$=MM.Info(platform)
Dim integer r,it,ani,yt,x,y,ID,Row,Column,Diamond,gems,Time_,WaterDischarge
Dim integer n,Canv_x,Canv_y,PL_x,PL_y,spaddr%,offs,lt,spl,tt,Pl_Dead,mus=1
Dim integer lives=4,exi=0,score=0,level=1
Font 9
If mite$="Game*Mite" Then
  FRAMEBUFFER create
  FRAMEBUFFER write f
  key$=ctrl_gamemite$(1)
Else
  MODE 2
EndIf
intro
CLS
score=0
Text 0,232,"0/0       04            000                   00000"
yt=5
Restore spindex
spaddr% = Peek(CFUNADDR "SPRITE_Data")
For y=0 To 39:Read x:spr%(y)=spaddr%+x:Next
Restore sp2
For y=0 To 9:Read x:Sprit3%(y)=x:Next

nxtMap:
pl_Dead=0:exi=0:Diamond=-1
getlevel
'Restore l4
Read ID,Row,Column,gems,Time_,WaterDischarge
Time_=Time_/1000
For r=1 To Row
  Lev$(r)=""
  Read Ro$:Ro$=expand$(Ro$)
  x=Instr(Ro$,"1"):If x Then PL_x=x:PL_y=r
  For n=1 To Len(Ro$)
    Lev$(r)=Lev$(r)+Chr$(Val("&H"+Mid$(Ro$,n,1)))
  Next
Next
toggle_snd
addgem
Canv_x=Column-20:Canv_y=row-13:ani=0
offs=0:lt=0
spl=32:tt=Timer
Do
  If Not lt Then animate
  Move_canv
  showscreen Canv_x,Canv_y,offs
  Key$=Inkey$
  If Key$="" And mite$="Game*Mite" Then Key$=ctrl_gamemite$()
  Move_PL
  move_stne' 4 rows at once
  'Inc n
  Inc lt:lt=lt Mod 3
  If key$="m" Then mus=Not(mus):toggle_snd
  If Pl_Dead Then
   Inc lives,-1:Text 66,232,Str$(lives)
   If lives Then GoTo nxtMap
   GoTo Game_over
  EndIf
  Text 144,232,Str$(Time_-Int((Timer-tt)/1000))+" "

  If mite$="Game*Mite" Then FRAMEBUFFER copy f,n,b:Pause 20

Loop

End


Game_over:


End
leveldone:
  Inc Level
  Inc score,(Time_-Int((Timer-tt)/1000))
  Play modsample 21,3: Showscore:Pause 1000
 GoTo nxtMap

Sub getlevel
Select Case level
  Case  1:Restore l1
  Case  2:Restore l2
  Case  3:Restore l3
  Case  4:Restore l4
  Case  5:Restore l5
  Case  6:Restore l6
  Case  7:Restore l7
  Case  8:Restore l8
  Case  9:Restore l9
  Case 10:Restore l10
  Case 11:Restore l11
End Select
End Sub




Function ctrl_gamemite$(init)
'from Petscii Robots
  If Not init Then
    Local bits = INV Port(GP8, 8) And &hFF, s$
    Select Case bits
        Case 0    : Exit Function
        Case &h01 : s$ = Chr$(129)       ' Down
        Case &h02 : s$ = Chr$(130)       ' Left
        Case &h04 : s$ = Chr$(128)       ' Up
        Case &h08 : s$ = Chr$(131)       ' Right
        Case &h10 : s$ = Chr$(27)        ' Select/Escape
        Case &h20 : s$ = " "             ' Start/Space
        Case &h40 : s$ = "m"             ' Fire B/Mute
        Case &h41 : s$ = "toggle-item"   ' Down + Fire B
        Case &h44 : s$ = "toggle-weapon" ' Up + Fire B
        Case &h80 : s$ = "move"          ' Fire A
        Case &h81 : s$ = "fire-down"     ' Down + Fire A
        Case &h82 : s$ = "fire-left"     ' Left + Fire A
        Case &h84 : s$ = "fire-up"       ' Up + Fire A
        Case &h88 : s$ = "fire-right"    ' Right + Fire A
        Case &hC0 : s$ = "map"           ' Fire A + Fire B
    End Select
    ctrl_gamemite$ = s$
    Exit Function
  Else
    ' Initialise GP8-GP15 as digital inputs with PullUp resistors
    Local i
    For i = 8 To 15
      SetPin MM.Info(PinNo "GP" + Str$(i)), Din, PullUp
    Next
  EndIf
End Function

Sub toggle_snd
  If mus Then
    Play stop:Play modfile "Sounds/gems'n'rocks.mod"
  Else
    Play stop:Play modfile "Sounds/silence.mod"
  EndIf
End Sub

Sub addgem
  Inc Diamond
  Text 0,232,Str$(Diamond)+"/"+Str$(gems)+" "
  If exi=0 Then exi=(Diamond>=gems)
  Play modsample 19,2
Exit Sub

Sub Showscore
  Local stxt$=Str$(score)
  Do
    stxt$="0"+stxt$
  Loop Until Len(stxt$)>4
  Text 276,232,stxt$
End Sub

Sub Move_PL
'Move Player
Local integer ox,oy,pa,bl,Nothing=0,Dirt=2,bld=4,gem=5, pl=1,ex=9
 If Key$<>"" Then
   pa=Peek(varaddr lev$(pl_y))+pl_x
   Poke BYTE  pa,Nothing 'clear byte at Players position
   Select Case Asc(key$)
'     Case 115
'      Save image "Screenshot.bmp"
'-----------------------------------
     Case 130 'Left
        spl=8 'set Sprite number
  bl=Peek(BYTE pa-1)And 15
  Select Case bl
          Case Nothing:Inc pl_x,-(pl_x>3):Play modsample 17,1
          Case Dirt:Inc pl_x,-(pl_x>3):Play modsample 16,1
          Case bld
            If Peek(BYTE pa-2)=Nothing Then
              Inc pl_x,-(pl_x>3):Poke BYTE  pa-2,bld
              Play Modsample 16,1
            EndIf
          Case gem:addgem:Inc pl_x,-(pl_x>3):Inc score,15:showscore
          Case ex:If exi Then GoTo leveldone

  End Select
'-----------------------------------
     Case 131 'right
        spl=12
        bl=Peek(BYTE pa+1)And 15
  Select Case bl
          Case Nothing:Inc pl_x,(pl_x<(Column-3)):Play modsample 17,1
          Case Dirt: Inc pl_x,(pl_x<(Column-3)):Play modsample 16,1
          Case bld
           If Peek(BYTE pa+2)=Nothing Then
             Inc pl_x,pl_x<(Column-2)):Poke BYTE  pa+2,bld
             Play Modsample 16,1
           EndIf
          Case gem:addgem:Inc pl_x,(pl_x<Column-3):Inc score,15:showscore
          Case ex:If exi Then GoTo leveldone

   End Select
'-----------------------------------
     Case 128'up
        spl=16
        bl=Peek(BYTE pa-65)And 15
          Select Case bl
            Case Nothing:Inc pl_y,-(pl_y>4):Play modsample 17,1
            Case Dirt:  Inc pl_y,-(pl_y>4):Play modsample 16,1
            Case gem:addgem:Inc pl_y,-(pl_y>4):Inc score,15:showscore
            Case ex:If exi Then GoTo leveldone
          End Select
'-----------------------------------
     Case 129'down
        spl=4
  bl=Peek(BYTE pa+65)And 15
    Select Case bl
        Case Nothing:Inc pl_y,(pl_y<(row-3)):Play modsample 17,1
        Case Dirt: Inc pl_y,(pl_y<(row-3)):Play modsample 16,1
        Case gem: addgem:Inc pl_y,(pl_y<(row-3)):Inc score,15:showscore
        Case ex:If exi Then GoTo leveldone
    End Select
     Case  27'esc
        MODE 1
        End
    End Select
    pa=Peek(varaddr lev$(pl_y))+pl_x
    Poke BYTE  pa,1
   Else
      spl=0
  EndIf
End Sub

Sub Move_canv
  If PL_y>Canv_y+6 Then
    Inc Canv_y,(Canv_y<row-13)
  Else
    If PL_y<Canv_y+5 Then Inc Canv_y,-(Canv_y>1)
  EndIf
  If PL_x>Canv_x+10  Then
    Inc Canv_x,(Canv_x<Column-20)
  Else
    If PL_x<Canv_x+10 Then Inc Canv_x,-(Canv_x>1)
  EndIf
End Sub

Sub move_stne
'Gravitation. Test if there something to move down?
' only Row (yt) at a time
  Local integer s1,ss,x,y,vl,v2,f
  For f=1 To 4
  y=yt:ss=Peek(varaddr lev$(y))
  For x = 3 To Column-3
     s1=ss+x
     v2=Peek(BYTE s1):vl=v2 And 15
   'Gem or Bolder?
     If vl= 4 Or vl=5 Then
      If Peek(BYTE s1+65)=0 Then
        Poke BYTE s1+65,vl+128 'Move stone/gem down,set falling flag
        Poke BYTE s1,0         'Clear the old position
       GoTo weiter
       Else
         Poke byte s1,vl
      EndIf
    'falling on something?
    If v2>128 Then
    Select Case Peek(BYTE s1+65)
      Case 1:pl_Dead=1:Play modsample 18,2:Pause 1000:GoTo weiter
      Case 2,3,4,5 'dirt rock,gem
        v2=v2-128:Play modsample 18,3:GoTo weiter
      Case 6
        v2=v2-128:'Butterfly
        'add gems at the position
      Case 7:v2=v2-128:'firefly
    End Select
    EndIf
     'on top of a Bolder or gem?
      If (Peek(BYTE s1+65) And 15)<>4 And (Peek(BYTE s1+65)And 127)<>5 Then GoTo weiter
        ' Check left down diagonal if it can't move down
        If Peek(BYTE ss+x-1) = 0 And Peek(BYTE s1+64) = 0 Then
          Poke BYTE s1+64,vl+128 ' Move stone/gem to left down
          Poke BYTE s1,0    ' Clear the old position
          GoTo weiter
        EndIf

      ' Check right down diagonal if it can't move down or right down
        If Peek(BYTE s1+1)=0 And Peek(BYTE s1+66) = 0 Then
          Poke BYTE s1+66,vl+128 ' Move stone/gem to right down
          Poke BYTE s1,0    ' Clear the old position
        EndIf
   Else
         Poke byte s1,vl
     EndIf
     weiter:
    Next
    Inc yt,-1:If yt=0 Then yt=Row - 2
  Next
End Sub



Sub showscreen x,y,xo
  Local integer y1,x1,x2,y2,ss,nr,xo1
  x2=x:xo1=xo<<2:ss=Peek(varaddr lev$(y))
  For y1=0 To 220 Step 16
    For x1=0 To 320 Step 16
      Blit memory spr%(Sprit3%((Peek(BYTE ss+x2)And 15))),x1-xo1,y1:Inc x2
    Next
    x2=x:Inc ss,65
  Next
End Sub

Function expand$(Canv_xl$)
 Local n%=1,nmb%,tmp$,co$
 Do
  If Asc(Mid$(Canv_xl$,n%,1))< 71 Then
     tmp$=tmp$+Mid$(Canv_xl$,n%,1)
  Else
     co$=Hex$(Asc(Mid$(Canv_xl$,n%,1))-71):Inc n%
     nmb%=Val("&H"+Mid$(Canv_xl$,n%,1)):tmp$=tmp$+String$(nmb%+1,co$)
  EndIf
  Inc n%
 Loop Until n%>Len(Canv_xl$)
 expand$=tmp$
End Function

Sub animate
  Sprit3%(1)=Spl+ani:Sprit3%(5)=20+ani:Sprit3%(6)=36+(ani And 1)
  Sprit3%(7)=28+Ani:If exi Then Sprit3%(9)=24+ani

  Inc ani:ani=ani And 3
End Sub

Sub intro
CLS :Load image "images\title.bmp"
'Save image "images\Title2.bmp"
If mite$="Game*Mite" Then FRAMEBUFFER copy f,n
Pause 2000
Box 48,226,224,16,,0,0
Text 52,230,"CAVE:   Highscore   LEVEL:"
If mite$="Game*Mite" Then FRAMEBUFFER copy f,n
Pause 2000
End Sub

sp2:
Data  32, 0, 34, 39, 35,20,36,28,4,24,38
'
'Game Data ---------------------------------------------------------------------
'
'Level Data
'Empty    0  32
'Miner    1  0
'Earth    2  34
'Border   3  39
'Rock     4  35
'Gem      5  20
'Butterfly6  36
'Monster  7  28
'Water    8  4
'Door     9  24
'Wall     A
'Level Data
' ID,Row,Column,gem,Time_,WaterDischarge
' compressed Level Data
L0: 'Debug level
Data 0,18,33,20,150000,0
Data "IFIF2","IFIF2"
Data "22JFJC22","2231:245I24I3324I33422422322"

Data "22JFJC22","IFIF2","IFIF2"
Data "IFIF2","IFIF2"
Data "IFIF2","IFIF2"
Data "IFIF2","IFIF2"
Data "IFIF2","IFIF2"
Data "IFIF2","IFIF2"
Data "IFIF2","IFIF2"
Data "IFIF2","IFIF2"

L1:
Data 1,33,33,1,120000,0,"IFIF2","IFIF2","22JFJC22","22312245I24I3324I33422422322"
Data "223IB522424542422442322","223I53I2422324424I242244322"
Data "2232424223I242232242422424242322","223524I23I53424422342K22322"
Data "223I53I53I535I4322","22J422J42J623223323322","223I7424223I25I8322"
Data "2232242423I4432445423224242322","22324I33I53I443244542322"
Data "223I342324I2532424I342422322","22324I33I252232242242242424322"
Data "2232524223IC3224242322","22J422J42J62J3223322","223I244224I2423424I235I4322"
Data "22324I332K222324224I7322","223224I2325K2232242423244254322"
Data "223I2524342242434I43224422322","2234I4342422432242523224224322"
Data "223I53IC3I5322","22J522J4I2J622J322","223224I544223I53I45322"
Data "2234I34322442432244223I2442322","223I4432242423I34I34I2322"
Data "223I25243I53I35I542322","2232244223224I444I2324I3322"
Data "223IB522422423I49322","22JFJC22","IFIF2","IFIF2"
L2:
Data 2,26,43,20,150000,0,"IFIFIA","IFIFIA","22JFJFJ622","2231I64I2524I354IA4I3322"
Data "2232J22J22J22J22J22J22J25J22J22322","2232J22J25J22J22J22J22J24J22J25322"
Data "2232J22J22J22J24J22J22J22J22J22322","223I94IC4I942322"
Data "2235J22J22J22J22J22J22J22J22J22322","2232J22J22J22J22J25J22J22J22J22322"
Data "2232J24J22J22J24J22J24J22J22J22322","2234ID5IB524I5322"
Data "2232J22J22J22J22J22J22J22J24J22322","2232J22J24J22J22J24J22J22J22J22322"
Data "2235J22J22J24J22J22J25J22J22J22322","223I55I95I74I6422322"
Data "2234J22J22J25J22J22J22J22J22J22322","2232J22J22J22J22J22J22J22J22J25322"
Data "2232J24J22J22J22J24J24J22J22J22322","223ID4I65I44225I34322"
Data "2232J22J22J22J22J22J22J22J22J22322","2232J22J22J25J22J22J22J22J22J22322"
Data "223I25224IB4I545I8922","22JFJFJ622","IFIFIA","IFIFIA"
L3:
Data 3,26,44,25,200000,4000,"IFIFIB","IFIFIB","22JFJFJ722"
Data "22320220244I40220201I304G2224202002322","223022020220200I30242020I2044224225202322"
Data "2234I40020200I24I2420I24JB22","2232425I20206I502244220I30I4020322"
Data "22JC2020220044220I30I24I3322","2234200I5022020I202202402242006I4922"
Data "2234240I502244220I34I24I502402322","223I2022400I24422440I2400I20I302442322"
Data "223I242242020I30I26I502422G22242322","223I242242020I34I200I402422G22242322"
Data "22320I24220240220200I4G32202024I3322","22322G22424I30200I5404422420254I2322"
Data "22324250020200I20202020I2K2224I34I2322","223I60200I202420202024240I24I302322"
Data "223200I34I300224244220I34I24I2024322","223I4024024020I2K222424I20022424I2322"
Data "22300I502242020I302402242044I6322","22340I50224422420220I24I50244I2322"
Data "2232022420I202202400I200I20I34244I2322","223242546024I34I24822022424600I254I2322"
Data "22JFJFJ722","IFIFIB","IFIFIB"
L4:
Data 4,26,44,15,200000,0
Data "IFIFIB","IFIFIB","22JFJFJ722","223020422020220224202210220200204I502322"
Data "22324240I50224I20I34I24I454242322","22324224I260I242242422424I2JB22"
Data "22392254224200I44I40I7G3224322","22JC22424I30I84G2224322"
Data "223200I50200224200I4440I4K2224322","223I200I2G220224200I442042202424022322"
Data "22322424224G2I34I40I2044224I3422322","223I4402G222024004020I2K222424I30322"""
Data "223424I24200I56224I20I34I354204322","223I54240I844224I2JB22"
Data "223244I5422420I20220240224200I20022322","22JC4I74I24I5024422322"
Data "223I500I2522420224244I8024422322","2232242242020I2J7I8G222422322"
Data "22302200I3422404I250I20I504022422322","2234I2402424I2420700I3G320202402204322"
Data "22320022604I3G3I6440024I244I24322","2234240224200I442420I3K224I34I24322"
Data "223I20024240I4424I5K224I5422322","22JFJFJ722","IFIFIB","IFIFIB"
L5:
Data 5,26,44,3,60000,0
Data "IFIFIB","IFIFIB","22JFJFJ722","22342402K22322524I243I25I2423I254I2322"
Data "223I25242423I2K222434I3422434I24240322"
Data "223I302244320I302232244044223I34244322"
Data "223420220K2324I342234I5423I64322","223424I242232402242443I6423I64322"
Data "22344224I33I24I434244I43I2G222322","223224244224344I24I234244I43I24G23322"
Data "223224I24223I2022424342242022432042G3322"
Data "2234242J86J84J824004322","22324200I4K3224202002244I2042243I2322"
Data "2234240I5K322424244I24224244234244322"
Data "22320242420322K2224I34I24I44324244322"
Data "22320242420322JF34423224I2322","223022K3234I34I24I20244I332424024322"
Data "2234I2K223424I20422424I242443I4429322"
Data "223424I303402242K2I64243I5422322","223224I343224I54244I43422424I24322"
Data "2234244224234I24I34144I54224022422322"
Data "2234I24I23224246I54I200226I245422322"
Data "223442520223224244I542242442G2424I2322","22JFJFJ722","IFIFIB","IFIFIB"
L6:
Data 6,26,44,40,250000,0
Data "IFIFIB","IFIFIB","22JFJFJ722","223420I244I4420224I74I442252322"
Data "223I4524I64I34I34224I40220322","223I645324232203I234I24I200220I2322"
Data "2232JA23I232243I442206I5322","2234I73I2324230523I44I9322"
Data "22344224I332423I23220344I54225I3322","223224I4434423I23224344I84I24322"
Data "2232JA232423024324I34200I2524322","223424I53I232423224324225I206I2422322"
Data "22324I63442322532243I20I652422322","2230I7344032243I23I24224I44I2322"
Data "2232JA2J243I23I24I74200322","223I2420I23I23422342232422424200I5322"
Data "223I30442432423I2352232240I306I45322"
Data "223I3424223252322432423I24200I8322","2232JA23I23I23I24240I8322"
Data "223224I532423I234243I54224I5322","223421I242032423I234243I84522022322"
Data "223I34I335223I23I23I30I242252422322"
Data "22344I6324235223I232242252524224I2922","22JFJFJ722","IFIFIB","IFIFIB"
L7:
Data 7,26,44,40,80000,6000
Data "IFIFIB","IFIFIB","22JFJFJ722","2237G41GFGD7322","2230IFIFI30322"
Data "2230IF28IF220322","2230IFIA8I70322","2230I24IFIB4I20322"
Data "2230IC4I74IC0322","2230IFIFI30322","2230IFIFI30322","2230IFIFI30322"
Data "2230I74IF224I70322","2230IFIFI30322","2230IFIFI30322"
Data "2230IFIFI30322","2230IFIFI30322","2230IFIFI30322","2230IFIFI30322"
Data "2230IFIFI30322","2230I58IFI58I50322","2230IFIFI30922"
Data "2237GFGFG37322","22JFJFJ722","IFIFIB","IFIFIB"
L8:
Data 8,26,44,110,150000,3000
Data "IFIFIB","IFIFIB","22JFJFJ722","2298GF008GF08322"
Data "2230J80JB0J80J20322","22303242420422022042240K3I4424I330322"
Data "22303240I2422024I40I24I202244224230322"
Data "22303I300I2404I24I244224I642230322","22303044IA420I340I40I20230322"
Data "22300424I2424I24I542240I2022420030322"
Data "223032242242424I64I40424202244200322"
Data "223032K2I34224I2042240224I344I330322"
Data "223034I44I2040I340I24I20I3G230322","22303420I30I30I2K220I3G2I4430322"
Data "22300I3022K220I41224I24I204242430322"
Data "22303024220I34420202020424024224I20230322"
Data "22300I44I70044242420240220424030322"
Data "22303420I3402424204242K2242420I4G2322"
Data "2230342204I34I34424I34I44I24230322"
Data "22303440I24I744I20242420I342230322"
Data "22303I342242402424I44I2404424I2430322"
Data "2230J20JFJ20J40J50322","2238GF08GF008322","22JFJFJ722","IFIFIB","IFIFIB"
L9:
Data 9,26,44,17,150000,0
Data "IFIFIB","IFIFIB","22JFJFJ722"
Data "223244224320204232025429242422422404I240322"
Data "22323233243244I2422453224424240242424I2322"
Data "22303224I2424340420I24224I30242243024322"
Data "22324305420244024203K2I242K222K224254322"
Data "223022K20I2420K22242242352343K2232022322"
Data "22320I44022K22422302330K23242442K3322"
Data "223434243224502425242200I33230402424422322"
Data "22320K232K223202042K233244244230254304322"
Data "223K322024423K202442242022023340432044322"
Data "22324232052422324223422422024234034344024322"
Data "2234243K223232023I35344042523044242423322"
Data "223243424233I503344242424543442420401322"
Data "2233242K2243422302424242244224I24220322322"
Data "22330234424I3J22242323I20424202K2242322"
Data "223224I20242324I34I34240203230I2040322"
Data "2232420242454242042K2240303404I24020234322"
Data "223324I242424224332423I342424244244024322"
Data "2232422323220I243202242252204I4443425322"
Data "22304322342243204220224I334434244322K2322"
Data "2230252032K232442422442024424425I532322"
Data "22JFJFJ722","IFIFIB","IFIFIB"
L10:
Data 10,26,44,35,150000,0
Data "IFIFIB","IFIFIB","22JFJFJ722","223224I44I64I24221I44224I242322"
Data "223IFIFI5322","223IFIFI5322","223IFIFI5322","223IFIFI5322"
Data "223IFIFI5322","223IFIFI5322","22JA2332332332332J22JB22"
Data "223IA3IC3I500I3322","223I29I5332332332332332J2I306I3322"
Data "223I93IF3I50022322","223I6J32332332332332332J4220622322"
Data "223I63IFI63I5322","22J82J52332332332332332J722"
Data "223IFIFI5322","2232332332J22332J22332J22332J22J622"
Data "223I6G2I3G2I3G2I3G2I6322","2235I5G2I3G2I3G2I3G2I6322"
Data "22355I34G2I24G2I24G2I24G2I6322","223L2I24207I24207I24207I24207I6322"
Data "22JFJFJ722","IFIFIB","IFIFIB"
L11:
Data 11,26,44,90,150000,1200,"IFIFIB","IFIFIB","22JFJFJ722"
Data "2230403432453GFGB322","223G23432243GFGB322"
Data "223G234324230064004004004004004004004G2322"
Data "223G2343I232JFJ800322","223404223L202339IB43G23006300322"
Data "223G2303I232335IA423G23522300322"
Data "223G2303422323355IA43G23424300322"
Data "223G230320232JB23223G23252300322"
Data "2230403032023233GA3223G23422300322"
Data "223G2303I23233G23G23G23423G23242300322"
Data "223G23032423233G23G23G23423G23525300322"
Data "223G2303I23233G23G23G23223G23I2300322"
Data "2234043032253233G23G23G23223G23225300322"
Data "223G23032253233G23G23G23223G23522300322"
Data "223G23035223233G23G23G23223G23524300322"
Data "223G230352232338003G23G23223G23522300322"
Data "223G2300I2JF2J5225300322","223G230300635IE53G23425200322"
Data "223G2303L2332JF0063442300322","223100303L235IFI30I2300322"
Data "22JFJFJ722","IFIFIB","IFIFIB"

'
' 8x8 Font (Martin H.)
' Font type    : Full (95 ChArACtErs)
' Font size    : 8x8 pixels
' Memory usage : 764 Bytes
DefineFont #9
  5F200808
00000000 00000000 18181818 00180018 006C6C6C 00000000 367F3636 0036367F
3E683F0C 00187E0B 180C6660 00066630 386C6C38 003B666D 0030180C 00000000
3030180C 000C1830 0C0C1830 0030180C 3C7E1800 0000187E 7E181800 00001818
00000000 30181800 7E000000 00000000 00000000 00181800 180C0600 00006030
7E6E663C 003C6676 18183818 007E1818 0C06663C 007E3018 1C06663C 003C6606
6C3C1C0C 000C0C7E 067C607E 003C6606 7C60301C 003C6666 180C067E 00303030
3C66663C 003C6666 3E66663C 00380C06 18180000 00181800 18180000 30181800
6030180C 000C1830 007E0000 0000007E 060C1830 0030180C 180C663C 00180018
6A6E663C 003C606E 7E66663C 00666666 7C66667C 007C6666 6060663C 003C6660
66666C78 00786C66 7C60607E 007E6060 7C60607E 00606060 6E60663C 003C6666
7E666666 00666666 1818187E 007E1818 0C0C0C3E 00386C0C 70786C66 00666C78
60606060 007E6060 6B7F7763 0063636B 7E766666 0066666E 6666663C 003C6666
7C66667C 00606060 6666663C 00366C6A 7C66667C 0066666C 3C60663C 003C6606
1818187E 00181818 66666666 003C6666 66666666 00183C66 6B6B6363 0063777F
183C6666 0066663C 3C666666 00181818 180C067E 007E6030 6060607C 007C6060
18306000 0000060C 0606063E 003E0606 42663C18 00000000 00000000 FF000000
7C30361C 007E3030 063C0000 003E663E 667C6060 007C6666 663C0000 003C6660
663E0606 003E6666 663C0000 003C607E 7C30301C 00303030 663E0000 3C063E66
667C6060 00666666 18380018 003C1818 18380018 70181818 6C666060 00666C78
18181838 003C1818 7F360000 00636B6B 667C0000 00666666 663C0000 003C6666
667C0000 60607C66 663E0000 07063E66 766C0000 00606060 603E0000 007C063C
307C3030 001C3030 66660000 003E6666 66660000 00183C66 6B630000 00367F6B
3C660000 00663C18 66660000 3C063E66 0C7E0000 007E3018 70707000 002070F8
00181818 00181818 F8702000 00707070 00466B31 00000000 FFFFFFFF FFFFFFFF
End DefineFont

spindex:
Data 0,100,200,296,392,496,600,700,796,884,972,1056,1144,1236,1324,1408
Data 1496,1596,1692,1788,1888,1968,2052,2140,2224,2344,2464,2568,2688
Data 2808,2944,3072,3200,3336,3472,3596,3704,3828,3920,4056

CSub SPRITE_Data
00000000
'Offset  0
'BD00 is compressed
80100010
0221040F 08C2F1C1 F1C10121 05C302C1 01C30121 06C301F2 01C101C1 01C101F2
02C505C1 21010FC5 F201F103 F201F201 F305F101 F301F201 F8052101 F402C206
C104C202 F204F201 C204C101 01F2C402 03C506C1 05C106C1 04F405C4 000002F4
'Offset  100
'BD01 is compressed
80100010
0221040F 08C2F1C1 F1C10121 05C302C1 01C30121 06C301F2 01C101C1 01C101F2
02C505C1 21010FC5 F801F103 F305F101 F301F201 F8052101 F402C206 C104C202
F204F201 C105C101 01F2C402 01F203C1 05C103C5 06C405F2 02F405F2 00000000
'Offset  200
'BD02 is compressed
80100010
0221040F 012108C4 05C302C3 01C30121 06C301F2 01C101C1 01C101F2 02C505C1
21010FC5 F201F103 F201F201 F305F101 F301F201 F8052101 F402C107 F204C102
F2C304C3 C801F202 C204F201 C102C101 C807C201 F304F307 00000003
'Offset  296
'BD03 is compressed
80100010
0221040F 08C2F1C1 F1C10121 05C302C1 01C30121 06C301F2 01C101C1 01C101F2
02C505C1 21010FC5 F801F103 F305F101 F301F201 F7052101 C2042102 C202F402
F201C104 C101F204 C402C204 C206C202 C202C101 F307C808 0003F304
'Offset  392
'BD04 is compressed
80100010
0121040F 08C2F1C2 F1C20121 042101C4 F1C20121 052101C6 01C5F1C2 02C105C1
F206C7F1 C202C201 F1022102 C401F201 F208F107 F104F102 F301F201 F704F103
2103C301 C301F502 C104F101 C201C105 C1F202F2 C402C101 F203F201 062102C6
00000BF2
'Offset  496
'BD05 is compressed
80100010
0121040F 08C2F1C2 F1C30121 022105C4 06C6F1C2 04C6F1C3 04C10121 06C101C4
02C101F3 022101C2 01F302F1 01F105C4 06F207F1 01F201F2 05F102F3 01C101F7
012102F1 02F401C1 04C205C3 02F101C4 C201C1F2 C101C202 C9F203F2 0BF205F1
00000000
'Offset  600
'BD06 is compressed
80100010
0221040F 07C2F1C2 F1C40121 012105C3 01C2F1C6 F1C60521 01C105C3 06C104C4
01C102C2 01C408F3 04F102F3 01F107F2 02F102F1 01F201F3 01F104F2 06F701C1
01F402C3 01F104C1 04C204C4 C201C1F2 C101C202 C9F103F2 03F20DF2 00000000
'Offset  700
'BD07 is compressed
80100010
0221040F 07C2F1C2 F1C40221 022105C2 06C2F1C6 F1C501C1 012104C2 C102F1C7
C202C206 C409F201 F101F201 F202F102 F102F108 F201F303 C305F101 F104F701
F501C301 01C2F205 04C105C1 02C401F2 F2C101C1 0DF2C607 000003F2
'Offset  796
'BD08 is compressed
80100010
F1C2050F 01F107C3 05C6F1C2 F1C101F1 02C106C8 06C202C2 21010FCC F201F104
F108F202 F301F201 F7042103 F204C201 C201F501 F202F201 C301F302 C204F201
C209C503 C101C101 21062101 F40BC601 00000005
'Offset  884
'BD09 is compressed
80100010
F1C2050F 01F208C3 F206C6F1 C109C801 C102C101 010FCC06 01F10521 08F201F3
01F301F1 042102F2 042102F8 01F60121 012104C2 03F40121 012104C2 01F204C1
01C406C2 08C101F2 04C201C1 03F306F1 000003F3
'Offset  972
'BD0A is compressed
80100010
F1C1060F 01F209C3 012105C6 09C701F2 07C102C2 21010FCC F101F704 F201F107
2102F401 2102F804 F2012104 C202F102 F2042104 C206C401 C301F201 F203F101
06C101C1 F204F1C1 F205F2C8 0003F206
'Offset  1056
'BD0B is compressed
80100010
F1C2050F 01F208C3 F206C6F1 C109C801 C102C101 010FCC06 01F60421 01F107F2
01F101F2 042102F2 042102F8 01F60121 012104C2 03F40121 012104C2 01F204C1
01C406C2 08C101F2 04C201C1 03F306F1 000003F3
'Offset  1144
'BD0C is compressed
80100010
0221040F 06C2F1C3 F1C60121 02F101C2 F1C80121 05F101C1 02C202C2 0FCC05C1
F2062101 F101F202 F201F308 2101F101 F701C204 C201F204 F201F501 C301F202
F202F301 C203C504 C101C107 2103C201 2102C606 0007F408
'Offset  1236
'BD0D is compressed
80100010
0221040F 06C2F1C3 F1C60121 2103F201 F201C801 C102C106 CC08C101 0521010F
01F301F2 01F208F1 02F101F3 06F80621 06F601C2 07F403C2 04F201C2 01C107C1
01C401F2 04F10421 01C101C2 03F30621 000004F3
'Offset  1324
'BD0E is compressed
80100010
0221040F 07C1F1C3 01C60121 012104F2 08F201C7 08C202C1 21010FCC F701F105
F201F407 2101F101 C206F806 F202F102 C4012105 F108F201 F201C301 F105C201
01C106C1 F203F2C1 F205F2C8 0003F206
'Offset  1408
'BD0F is compressed
80100010
0221040F 06C2F1C3 F1C60121 2103F201 F201C801 C102C106 CC08C101 0521010F
01F301F2 01F208F1 02F101F3 06F80621 06F601C2 07F403C2 04F201C2 01C107C1
01C401F2 04F10421 01C101C2 03F30621 000004F3
'Offset  1496
'BD10 is compressed
80100010
01F3050F 012108C2 05C401F3 03210121 05C202C2 05C80121 07C10121 01F107C2
02F201F2 01F103C1 01F201F2 04F101F2 06FA01F1 05F102F9 01C101F7 012102F1
02F401C1 04C205C3 02F101C4 C201C1F2 C101C202 C9F203F2 0BF205F1 00000000
'Offset  1596
'BD11 is compressed
80100010
01F3040F 01F309C3 042105C5 06C302C2 05C101C8 01C207C1 01F105C1 02F201F2
01F103C2 01F201F1 05F101F2 02F901F1 03F804F1 01F605F1 012103C3 02F301C1
04F101C3 01C203C2 F202F2C2 02C101C1 03F201C4 2103C5F2 000BF206
'Offset  1692
'BD12 is compressed
80100010
0221040F 06F301C2 01C40121 012105F3 04C202C2 07C80621 05C107C2 01F202C1
07F101F2 01F201F1 01F201F2 01FA04F1 02F102F1 01F104F9 06F701C1 01F402C3
01F104C1 04C204C4 C201C1F2 C101C202 C9F103F2 03F20DF2 00000000
'Offset  1788
'BD13 is compressed
80100010
0221040F 05F301C3 01C50121 012104F3 03C202C3 01C10521 01C105C8 04C107C2
01F202C2 07F101F2 01F201F1 01F101F2 02F102F1 02F101F9 05F803F1 05F601C3
02C301F1 04C101F3 C201C2F2 F204C203 C102C401 08F2C101 F20DF2C5 00000003
'Offset  1888
'BD14 is compressed
80100010
21040F0F 21012101 21012103 11071807 051276F1 1474F311 72F51103 F7110116
02117E19 11031776 21031675 15741101 11012105 06211473 72110121 21012113
11012106 21021271 0007120A
'Offset  1968
'BD15 is compressed
80100010
21040F0F 21012101 21012103 FA07F807 F672F105 F103F172 F174F474 F276F101
F17EF276 F176F701 F175F603 F5012103 2105F174 F173F401 01210621 21F172F3
21062101 F171F201 F20A2102 00000007
'Offset  2052
'BD16 is compressed
80100010
21040F0F 21012101 21012103 12071807 0511F176 11F37414 F5721603 F7180111
01117E12 11F67611 F5751103 01210311 11F47411 11012105 2111F373 11012106
2111F272 21062101 F1711101 0A210211 00000712
'Offset  2140
'BD17 is compressed
80100010
21040F0F 21012101 21012103 1A071807 16721105 11031172 11741474 12761101
117E1276 11761701 11751603 15012103 21051174 11731401 01210621 21117213
21062101 11711201 120A2102 00000007
'Offset  2224
'BD18 is compressed
80100010
F1030F0F F10231DC 31D13AD1 31D1F102 31D131F8 31D1F102 31F1D6F1 F10231D1
D1F131D1 31F1D134 F10231D1 D1F131D1 D131D231 31D131F1 31D1F102 D231D1F1
31F1D131 F10231D1 D1F131D1 31F1D134 F10231D1 D6F131D1 31D131F1 31D1F102
31D131F8 3AD1F102 F10231D1 D10231DC 00020F3D
'Offset  2344
'BD19 is compressed
80100010
F1030F0F F10231DC 31D13AD1 31D1F102 31D131D8 31D1F102 31D136D1 F10231D1
31D131D1 31D131D4 F10231D1 31D131D1 31D1F2D1 31D131D1 31D1F102 F2D131D1
31D131D1 F10231D1 31D131D1 31D131D4 F10231D1 36D131D1 31D131D1 31D1F102
31D131D8 3AD1F102 F10231D1 D10231DC 00020F3D
'Offset  2464
'BD1A is compressed
80100010
F1030F0F F10231DC 31D13AD1 3AD1F102 F10231D1 32D632D1 F10231D1 F4D132D1
31D132D1 32D1F102 F1D2F1D1 31D132D1 32D1F102 F1D2F1D1 31D132D1 32D1F102
32D1F4D1 F10231D1 32D632D1 F10231D1 31D13AD1 3AD1F102 F10231D1 D10231DC
00020F3D
'Offset  2568
'BD1B is compressed
80100010
F1030F0F F10231DC 31D13AD1 31D1F102 31D131D8 31D1F102 31D1F6D1 F10231D1
F1D131D1 31D1F1D4 F10231D1 F1D131D1 F1D132D1 31D131D1 31D1F102 32D1F1D1
31D1F1D1 F10231D1 F1D131D1 31D1F1D4 F10231D1 F6D131D1 31D131D1 31D1F102
31D131D8 3AD1F102 F10231D1 D10231DC 00020F3D
'Offset  2688
'BD1C is compressed
80100010
F20AF201 2101F401 0121F806 01210321 21F201F4 218201F2 03F201F2 F402F421
F4012104 0421F402 F402F421 F2052101 F2018201 F1022101 01218102 01810284
0181F221 2182F682 2102F181 2101F181 F1022101 81F10381 82F68201 01F18101
018A21F1 882104F1 21062101 21028401 0000040F
'Offset  2808
'BD1D is uncompressed
00100010
00000000 00000000 00202000 00000000 02020200 00020200 80FF2FF0 0FF0FF28
0FFFF2FF FF0FFFF0 0FFFF0FF FF2FFFF0 0FFFF2FF FF0FFFF0 80FF0FF0 0FF0FF08
FF028000 020800FF 20F8800F F0288F20 02F8828F F8088F02 20F88020 00088F20
FF88828F F80888FF 888820F0 0F208888 88020000 00020088 00000000 00000000
00000000
'Offset  2944
'BD1E is compressed
80100010
0121040F 01210C21 03210121 04210121 01F221F2 01F22182 21F201F2 01F402F4
02F401F4 21F421F4 01F402F4 01F201F2 018201F2 01F201F2 218102F1 81F28101
21018102 830181F2 F10121F1 F1812183 F1832102 83F12101 0181F103 0121F183
810183F1 21F101F1 0184F284 882104F1 21062101 21028401 0000040F
'Offset  3072
'BD1F is compressed
80100010
0121040F 01210C21 03210121 04210121 01F221F2 01F22182 21F201F2 01F402F4
02F401F4 21F421F4 01F402F4 01F201F2 018201F2 01F201F2 218102F1 81F28101
21018102 830181F2 F10121F1 F1812183 F1832102 83F12101 0181F103 0121F183
810183F1 21F101F1 0184F284 882104F1 21062101 21028401 0000040F
'Offset  3200
'BD20 is uncompressed
00100010
00000000 00000000 00202000 00000000 02020200 00020200 20202020 00202020
02020200 00020200 00202020 00202020 00020200 02020200 00000000 00202000
02020000 02020002 20202000 00200020 02020200 00000002 20202020 00000020
02020200 00020002 20202000 00202000 00020000 00020000 00000000 00000000
00000000
'Offset  3336
'BD21 is uncompressed
00100010
35111133 33511533 35511157 53557753 51513551 35555333 11555511 35531113
11555111 5F333111 33111111 33131113 13151111 33511111 33175111 35553331
3355F551 33113335 17111335 53311111 11111133 15113311 11171111 15533331
13317111 11151115 51115F13 15515553 11331555 53131553 31333355 53331533
00000000
'Offset  3472
'BD22 is compressed
80100010
810181A6 C3A2C4A3 810181A2 81A2C5A7 81018101 C6A28101 A10181A2 A101A1C2
A101A3C5 A4C3A3C4 01A7C681 A1C6A181 0181A381 C5A201A1 018101A1 A1C3A181
A2C3A181 C6A10181 0181A501 01A1C7A1 C7A201A4 810181A1 C5A38201 02A301A2
01A2C3A4 01A3C2A1 C4A101A7 A48101A3 C5A18101 00000000
'Offset  3596
'BD23 is compressed
80100010
4622040F 43210621 44F141F1 43210321 022143F6 42F94121 42210121 43F241F6
41F34122 44F141F3 41F14122 44F241F1 462242F1 41F141F1 412243F1 48F14221
41214725 01224121 42214121 02254222 41214123 41224121 41240323 05234123
0526082A 00000000
'Offset  3704
'BD24 is compressed
80100010
0C830E81 0A81A183 1285A181 F1861204 0211F182 F182F111 F182F383 F382F112
1282F383 1282F382 1281F381 1281F381 F2811102 F2811281 11051181 1281F181
1181F181 F2811204 F2811281 11011281 1282F282 1182F282 0281F282 F2810212
0682F184 A183F182 06810181 A1810181 06110283 00820211
'Offset  3828
'BD25 is compressed
80100010
81048105 82048209 0482F107 F205F182 F2820482 81A1F105 81110211 1107F1A1
811281F1 110911F1 11F112F1 110C140B 110B11F2 11F182F1 81A1F109 F1A18112
1282F108 8209F182 810B8212 110B8102 060F1104 00000000
'Offset  3920
'BD26 is uncompressed
00100010
00A00000 00000000 00802A00 00000000 0202ACA0 00820200 20202A20 002020E0
02020200 00020200 00202020 00202020 00028200 020E0AE0 00000000 0020AEA0
02020000 02020A02 20202000 002E0020 E2020200 00000002 20802020 0000002A
02A2A200 00020002 20C02000 00202000 ACECA808 000A0008 00C00000 00000000
00000000
'Offset  4056
'BD27 is compressed
80100010
56325632 32F15532 5232F155 F45232F4 3254313F F1553256 32F15532 5232F452
3F5232F4 56325633 32F15532 5232F155 F45232F4 3254313F F1553256 32F15532
5232F452 3F5232F4 00000031
End CSub
